<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Models\Exclusion;
use App\Models\Stock;
use App\Models\Categorie;
use App\Models\ProduitUniteVente;
use App\Models\TypeVente;

class ExclusionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {   
      $table="";
        $Exclusions = Exclusion::whereEtat('!=1')->get();

         foreach($Exclusions as $Exclusion){
            $id_Produit=$Exclusion->Produit;
            $Produit=Stock::where('id',$id_Produit)->first();
            $table.="
                    <tr class='odd gradeX' style='height:20px;'>
                        <td>".$Produit->Produit.' '.$Produit->Propriete."</td>
                        <td>".$Exclusion->Quantite."</td>
                        <td>".$Exclusion->Montant."</td>
                        <td>".$Exclusion->Motif."</td>
                       <td>".$Exclusion->DateExclusion."</td>
                        
                        <td class='center f-icon'>
                            <form action='".route('Exclusions.destroy',$Exclusion)."' method='POST'>
                            <a href='".route('Exclusions.edit',$Exclusion)."'><i class='fa fa-pencil'></i></a>
                            
                                ".csrf_field()."
                                ".method_field('DELETE')."
                                <button><i class='fa fas-trash'></i>
                                    </button>
                            </form>
                        </td>
                      
                    </tr>";
                    }


        $tableListe=$table;
        return view('Exclusions.index', compact('tableListe'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {   
        $Produits = Stock::whereEtatstock('!=1')->get();
        $Categorie = Categorie::whereEtatcategorie('!=1')->get();
        $UniteVentes = TypeVente::whereEtat('!=1')->get();
        return view('Exclusions.create', compact('Produits', 'Categorie', 'UniteVentes'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
        'Produit' => 'required', 
        'Quantite' => 'required',
        'Motif' => 'required',
        'TypeVente' => 'required'
        ]);

     //Verification de la Quantite en Stock
     $QteStock = Stock::findOrFail($request->Produit);
     
     // Conversion de la qte Commande En pieces
     $QteDemande = $request->Quantite;
     $QteUV = ProduitUniteVente::whereProduitAndTypevente($request->Produit,$request->TypeVente)->first();
     $request->Quantite *= $QteUV->Qte;

     // //Recuperation du PU dans Pour la Qte Exclue 
     // $PU = ProduitUniteVente::whereProduitAndTypeVente($request->Produit,$request->TypeVente)->first();

     if ($QteStock->quantiteStock >= $request->Quantite) 
     {
        // Alors on soustrait la Qte en Stock de la Qte Exclue
        $QteStock->quantiteStock -= $request->Quantite;
         Exclusion::create([
            'Produit' => $request->Produit,
            'Quantite' => $QteDemande,
            'QtePiece' => $request->Quantite,
            'Montant' => $QteDemande*$QteUV->PU,
            'Motif' => $request->Motif,
            'UniteVente' => $request->TypeVente,
            'Exercice' => date('Y'),
            'Auteur' => session()->get('Matricule')
        ]);

         //Mis a Jour de la Qte en stock
         $QsteUpdate  = Stock::findOrFail($request->Produit);
         $QsteUpdate->update([
         'quantiteStock' => $QteStock->quantiteStock
         ]);
      
      session()->flash('message', 'L\'Exclusion effectuee');
     }
     else
     {
        session()->flash('messageDelete', 'La Quantite Exclue depasse la Qte En stock');
     }
    
       return redirect(route('Exclusions.index'));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $Exclusion = Exclusion::findOrFail($id);
        $Prod = Stock::findOrFail($Exclusion->Produit);
        $Produits = Stock::whereEtatstock(0)->get();
        $Categorie = Categorie::whereEtatcategorie('!=1')->get();
        $UniteVentes = TypeVente::whereEtat('!=1')->get();
        return view('Exclusions.edit', compact('Prod', 'Produits', 'Categorie', 'Exclusion', 'UniteVentes'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
       $this->validate($request, [
        'Produit' => 'required', 
        'Quantite' => 'required',
        'Motif' => 'required',
        'TypeVente' => 'required'
        ]);
       
        $QteExclusion = Exclusion::findOrFail($id);
        $QteStock = Stock::findOrFail($request->Produit);
        $QteStock->quantiteStock += $QteExclusion->QtePiece;

        // Conversion de la qte Commande En pieces
     $QteDemande = $request->Quantite;
     $QteUV = ProduitUniteVente::whereProduitAndTypevente($request->Produit,$request->TypeVente)->first();
     $request->Quantite *= $QteUV->Qte;

        if ($QteStock->quantiteStock >= $request->Quantite) 
        {
           // Alors on soustrait la Qte en Stock de la Qte Exclue
           $QteStock->quantiteStock -= $request->Quantite;
            $QteExclusion->update([
               'Produit' => $request->Produit,
               'Quantite' => $QteDemande,
               'QtePiece' => $request->Quantite,
               'Montant' => $QteDemande*$QteUV->PU,
               'Motif' => $request->Motif,
               'UniteVente' => $request->TypeVente,
               'Auteur' => session()->get('Matricule')
           ]);
   
         //Mis a Jour de la Qte en stock
         $QsteUpdate  = Stock::findOrFail($request->Produit);
         $QsteUpdate->update([
         'quantiteStock' => $QteStock->quantiteStock
         ]);
      
          session()->flash('message', 'L\'Exclusion effectuee');
         }
         else
         {
            session()->flash('messageDelete', 'La Quantite Exclue depasse la Qte En stock');
         }
    
           return redirect(route('Exclusions.index'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
      $QteExclusion = Exclusion::findOrFail($id);

      $QteStock = Stock::findOrFail($QteExclusion->Produit);

      $QteStock->quantiteStock +=$QteExclusion->QtePiece;

      $QteStock->update(['quantiteStock' => $QteStock->quantiteStock]);
      
      $QteExclusion->update(['Etat' => 1]);

      session()->flash('messageDelete', 'L\'exclusion a ete Annulee avec success!'); 
      return redirect(route('Exclusions.index'));
    }

    public function CorbeleExclusion()
    {
        $table="";
        $Exclusions = Exclusion::whereEtat(1)->get();

         foreach($Exclusions as $Exclusion){
            $id_Produit=$Exclusion->Produit;
            $Produit=Stock::where('id',$id_Produit)->first();
            $table.="
                    <tr class='odd gradeX' style='height:20px;'>
                        <td>".$Produit->Produit.' '.$Produit->Propriete."</td>
                        <td>".$Exclusion->Quantite."</td>
                        <td>".$Exclusion->Montant."</td>
                        <td>".$Exclusion->Motif."</td>
                       <td>".$Exclusion->DateExclusion."</td>
                        
                        <td class='center f-icon'>
                            <a href='".route('restaurationExclusion', $Exclusion)."'><img src='".url('icons/icons8_Reset_24px.png')."' width='20px' height='20px'></a>
                        </td>
                      
                    </tr>";
                    }


        $tableListe=$table;
        return view('Exclusions.CorbeleExclusion', compact('tableListe'));
    }


    public function restaurationExclusion($Exclusion)
    {
       $QteExclusion = Exclusion::findOrFail($Exclusion);

      $QteStock = Stock::findOrFail($QteExclusion->Produit);

      $QteStock->quantiteStock -=$QteExclusion->QtePiece;

      $QteStock->update(['quantiteStock' => $QteStock->quantiteStock]);
      
      $QteExclusion->update(['Etat' => 0]);

      session()->flash('message', 'L\'exclusion a ete Restauree avec success!'); 
      return redirect(route('CorbeleExclusion'));
    }

    public function getProduit(Request $request){
        $CAT=$request->get('id_categorie');
        $produit=Stock::where('categorie',$CAT)->get();
        $allProduit="";
        foreach ($produit as $keyProduit) {
            $allProduit.="<option value='".$keyProduit->id."'>".$keyProduit->Produit.' '.$keyProduit->Propriete."</option>";
        }
        echo $allProduit;
    }

        public function getTypeVente(Request $request){
        $prod=$request->get('idProduit');
        $produit=ProduitUniteVente::where('Produit',$prod)->get();
        $allProduit="";
        foreach ($produit as $keyProduit) {
            $typevend=TypeVente::whereIdAndEtat($keyProduit->TypeVente,0)->first();
            $allProduit.="<option value='".$typevend->id."'>".$typevend->TypeVente."</option>";
        }
        echo $allProduit;

    }

}
