<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Http\Requests;
use App\Models\Commande;
use App\Models\Approvisionnement;
use App\Models\Facture;
use App\Models\Exclusion;
use App\Models\Stock;
use Illuminate\Support\Facades\DB;

class TableauDeBordController extends Controller
{
    public function TableauDeBord()
    {   $CurentYear = date('Y');
        $NbreVente = Commande::whereEtatcommandeAndExercice('!=1',$CurentYear)->count('id');
        $MontantVente = Commande::whereEtatcommandeAndExercice('!=1',$CurentYear)->sum('Montant');

        $NbreAchat = Approvisionnement::whereEtatappAndExercice('!=1',$CurentYear)->count('id');
        $MontantAchat = Approvisionnement::whereEtatappAndExercice('!=1',$CurentYear)->sum('Pt');

        $NbreFacture = Facture::whereEtatfactureAndExercice(1,$CurentYear)->count('id');
        $MontantFacture = Facture::whereEtatfactureAndExercice(1,$CurentYear)->sum('Mtvac');

        $NbreExclusion = Exclusion::whereEtatAndExercice('!=1',$CurentYear)->count('id');
        $MontantExclusion = Exclusion::whereEtatAndExercice('!=1',$CurentYear)->sum('Montant');

    	return view('TableauDeBord', compact('NbreVente', 'MontantVente', 'NbreAchat', 'MontantAchat', 'NbreFacture', 'MontantFacture', 'NbreExclusion', 'MontantExclusion'));
    }
    
    public function graphic(){
              $CurentYear = date('Y');
              $comm = DB::table('commandes')
                     ->select(DB::raw('sum(Quantite) as quant_sup, sum(Montant) as MontantSup, Produit'))
                     ->whereExercice($CurentYear)
                     ->groupBy('Produit')
                     ->orderBy('quant_sup','desc')
                     ->limit(5)
                     ->get();
            $graph="";
            foreach ($comm as $keyComme) {
                $NomP = Stock::findOrFail($keyComme->Produit);
                $graph.=$NomP->Produit.' '.$NomP->Propriete."#";
                $graph.=$keyComme->quant_sup."#";
                 $graph.=$keyComme->MontantSup."#";
            }

            echo $graph;
    }
}
