<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Models\TypeVente;
use App\Models\Categorie;
use App\Models\Stock;
use App\Models\ProduitUniteVente;

class TypeVenteController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $TypeVentes = TypeVente::whereEtat('!=1')->get();
        return view('TypeVentes.index', compact('TypeVentes'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('TypeVentes.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
        'TypeVente' => 'required', 
        ]);

     //Verification de l'Unicite du champs typevente

       $NbreTv=TypeVente::whereTypevente($request->TypeVente)->count('id');
        
        if ($NbreTv == 0) 
        {
           TypeVente::create([
            'TypeVente' => $request->TypeVente,
            'Auteur' => session()->get('Matricule')
           ]);

           session()->flash('message', 'Type de Vente Crée avec success!');
        }
        else
        {
          session()->flash('messageDelete', 'Cet type de vente existe!');
        }
       
       return redirect(route('TypeVentes.index'));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {   
        $ProduitUniteVentes = ProduitUniteVente::whereTypeventeAndEtat($id, 0)->get();
        $table="";
        
         foreach($ProduitUniteVentes as $ProduitUniteVente){

            $id_prod=$ProduitUniteVente->Produit;
            $produit=Stock::where('id',$id_prod)->first();


            $id_TypeVente=$ProduitUniteVente->TypeVente;
            $TypeVente=TypeVente::where('id',$id_TypeVente)->first();


            $table.="
                    <tr class='odd gradeX'>
                        <td>".$produit->Produit.' '.$produit->Propriete."</td>
                         <td>".$TypeVente->TypeVente."</td>
                         <td>".$ProduitUniteVente->PU."</td>
                         <td>".$ProduitUniteVente->Qte."</td>
                        <td>".$ProduitUniteVente->created_at."</td>
                        
                        <td class='center f-icon'>
                            <form action='".route('ProduitUniteVentes.destroy',$ProduitUniteVente->id)."' method='POST'>
                            <a href='".route('ProduitUniteVentes.edit',$ProduitUniteVente->id)."'><i class='fa fa-pencil'></i></a>
                            
                                ".csrf_field()."
                                ".method_field('DELETE')."
                                <button><i class='fa fas-trash'></i>
                                    </button>
                                    
                                
                            </form>
                            
                        </td>
                      
                    </tr>";
                       # code...
        }

        $tableListe=$table;
        $TypeVente = TypeVente::findOrFail($id);
        $Categories = Categorie::whereEtatcategorie('!=1')->get();
        $Stocks = Stock::whereEtatstock('!=1')->get();
        return view('TypeVentes.show', compact('TypeVente', 'Categories', 'Stocks', 'tableListe'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $TypeVente = TypeVente::findOrFail($id);
        return view('TypeVentes.edit', compact('TypeVente'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
        'TypeVente' => 'required', 
        ]);

     //Verification de l'Unicite du champs typevente

       $NbreTv=TypeVente::whereTypeventeAndId($request->TypeVente, '!='.$id)->count('id');
        
        if ($NbreTv == 0) 
        { 
           $TypeVente=TypeVente::findOrFail($id);
           $TypeVente->update([
            'TypeVente' => $request->TypeVente
            ]);
           session()->flash('message', 'Type de Vente Modifié avec success!');
        }
        else
        {
          session()->flash('messageDelete', 'Cet type de vente existe!');
        }
       
       return redirect(route('TypeVentes.index'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
       $TypeVente=TypeVente::findOrFail($id);
       $TypeVente->update(['Etat'=>1]);
       session()->flash('messageDelete', 'le type  de vente a ete supprimé!');
       return redirect(route('TypeVentes.index'));
    }

    public function CorbeleTypeVente()
    {
        $TypeVentes = TypeVente::whereEtat(1)->get();
        return view('TypeVentes.CorbeleTypeVente', compact('TypeVentes'));
    }

    public function restaurationTypeVente($TypeVente)
    {
       $TypeVente=TypeVente::findOrFail($TypeVente);
       $TypeVente->update(['Etat'=>0]);
       session()->flash('message', 'le type  de vente a ete Restauré!');
       return redirect(route('CorbeleTypeVente'));
    }

    public function getProduit(Request $request){
        $CAT=$request->get('id_categorie');
        $produit=Stock::wherecategorieAndEtatstock($CAT,0)->get();
        $allProduit="";
        foreach ($produit as $keyProduit) {
            $allProduit.="<option value='".$keyProduit->id."'>".$keyProduit->Produit.' '.$keyProduit->Propriete."</option>";
        }
        echo $allProduit;

    }

        public function research(Request $request){
        $CAT=$request->get('produit');
        $idCat=$request->get('id_categorie');
        $produit=Stock::where('Produit','like','%'.$CAT.'%')->where('Categorie',$idCat)->get();
        $allProduit="";
        foreach ($produit as $keyProduit) {
            $allProduit.="<option value='".$keyProduit->id."'>".$keyProduit->Produit.' '.$keyProduit->Propriete."</option>";
        }
        echo $allProduit;

    }
}
