<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateStocksTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('stocks', function (Blueprint $table) {
            $table->increments('id');
            $table->string('Produit');
            $table->string('Propriete');
            $table->double('QteMin');
            $table->double('Quantite');
            $table->double('PU');
            $table->integer('Categorie');
            $table->string('Auteur');
            $table->integer('EtatStock');
            $table->dateTime('DateCreation')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('stocks');
    }
}
