@extends('layout.base', ['title' => 'StockApps - Modification Vente'])

@section('content')
        <div id="page-wrapper" >
            <div id="page-inner">
                <div class="row">
                    <div class="col-md-8">
                   </div>
                </div>
                 <!-- /. ROW  -->
                 <hr />
               <div class="row">
                <div class="col-md-12">
                    <!-- Form Elements -->
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            Enregistrement Nouveau Client
                        </div>
                        <div class="panel-body">
                            <div class="row">
                                
                                    <form role="form" method="POST" action="{{ route('Commandes.update', $Commande)}}">
                                      {{csrf_field()}}                       {{ method_field('PUT') }}            
                                    <div class="col-md-12">
                                     <div class="col-md-3"> 
                                       <div class="form-group">
                                            <label>Categorie Produit</label>
                                            <select class="form-control" id="Categorie" onchange="getProduitCommande(this)">
                                               @foreach($Categories as $Cat)
                                               <option value="{{ $Cat->id }}">{{ $Cat->Categorie}}</option>
                                               @endforeach
                                            </select>
                                        </div>
                                      </div>
                                      
                                      <div class="col-md-3">
                                       <div class="form-group">
                                            <label>Produit</label>
                                            <select class="form-control" name="Produit" id="Produit" onchange="getTypeVente(this)">
                                              <option value="{{ $Stock->id }}">{{ $Stock->Produit }} {{ $Stock->Propriete}}</option>
                                              @foreach($Stocks as $Stock)  
                                                <option value="{{ $Stock->id}}">{{ $Stock->Produit}} {{ $Stock->Propriete}}</option>
                                               @endforeach 
                                            </select>
                                        </div>
                                      </div>

                                      <div class="col-md-3">
                                       <div class="form-group">
                                            <label>Vente:</label>
                                          <select class="form-control" name="TypeVente" id="TypeVente">
                                              <option value="{{ $TypeVente->id }}">{{ $TypeVente->TypeVente }}</option>

                                              @foreach($UniteVentes as $UniteVente)  
                                                <option value="{{ $UniteVente->id}}">{{ $UniteVente->TypeVente}}</option>
                                               @endforeach 
                                            </select>
                                        </div>
                                      </div>  
                                      
                                       <div class="col-md-3">
                                        <div class="form-group">
                                            <label>Quantite en Piece</label>
                                            <input class="form-control" placeholder="Quantite" name="Quantite" value="{{ old('Quantite') ?: $Commande->Quantite }}" />

                                            {!! $errors->first('Quantite', '<span class="error">:message</span>') !!}
                                        </div>
                                       </div>

                                        <button type="submit" name="Suivant" class="btn btn-primary">Modifier</button>
                                     </div>
                                    </form>
                                    <br />                   
                            </div> 
                            </div>
                        </div>
                    </div>
                     <!-- End Form Elements -->
                </div>
            </div>
    </div>
             <!-- /. PAGE INNER  -->
            </div>
         <!-- /. PAGE WRAPPER  -->
@endsection 

<script type="text/javascript">
   function getProduitCommande(va){
     var id_categorie= $(va).val();

      $.get('{{ route('getProduitCommande') }}',
          {id_categorie:id_categorie},
          function(data){
            $('#Produit').html(data);
          });
   }

      function getTypeVente(va){
     var idProduit= $(va).val();

      $.get('{{ route('getTypeVente') }}',
          {idProduit:idProduit},
          function(data){
            $('#TypeVente').html(data);
          });
   }
</script>
