 @extends('layout.base', ['title' => 'StockApps - Corbeille Factures'])

@section('content')
              <div id="page-wrapper" >
            <div id="page-inner">
                <div class="row">
                   <div class="col-md-12">
                      <h2 style="color: red;font-weight: bold;">CORBEILLE # FACTURES</h2>  
                   <h5>Liste des Factures supprimées</h5>
                  </div>
                </div>
               <hr />
                 <!-- /. ROW  -->
                
               
            <div class="row">
                <div class="col-md-12">
                    <!-- Advanced Tables -->
                    <div class="panel panel-default">
                        <div class="panel-heading">
                          Liste des Factures supprimées
                        </div>
                        <div class="panel-body">
                            <div class="table-responsive">
                                <table class="table table-striped table-bordered table-hover" id="dataTables-example">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Client</th>
                                            <th>Auteur</th>
                                            <th>THTVA</th>
                                            <th>TTVAC</th>
                                            <th>Enregistré le:</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($Factures as $Facture)
                                      @if($Facture->EtatFacture == 2)
                                    <tr class="odd gradeX alert alert-danger">
                                            <td>{{ $Facture->id }}</td>
                                            <td>{{ $Facture->Client }}</td>
                                            <td>{{ $Facture->Auteur }}</td>
                                            <td>{{ $Facture->Mhtva }}</td>
                                            <td>{{ $Facture->Mtvac }}</td>
                                             <td>{{ $Facture->DateCreation->format('d/m/Y') }}</td>
                                             <td>
                                              <a href="{{ route('restaurationFacture', $Facture) }}"><img src="{{ url('icons/icons8_Reset_24px.png') }}" width="20px" height="20px"></a>
                                            </td>
                                             </td>
                                      </tr>
                                      @elseif($Facture->EtatFacture == 1)
                                       <tr class="odd gradeX">
                                            <td>{{ $Facture->id }}</td>
                                            <td>{{ $Facture->Client }}</td>
                                            <td>{{ $Facture->Auteur }}</td>
                                            <td>{{ $Facture->Mhtva }}</td>
                                            <td>{{ $Facture->Mtvac }}</td>
                                             <td>{{ $Facture->DateCreation->format('d/m/Y') }}</td>
                                             <td>
                                                <form action="{{ route('Factures.destroy', $Facture)}}" method="POST" style="display: inline-block;">
                                                {{ csrf_field() }}
                                                {{ method_field('DELETE') }}
                    
                                                <input class="btn btn-danger btn-sm" type="submit" name="" value="Supprimer">
                                              </form>

                                              <a target="blank" href="{{ url('Factures/pdfexport', $Facture->id) }}" style="color: white;text-decoration: none;"><img src=" {{ url('icons/icons8_Print_48px.png') }}" width="20px" height="20px"></a>
                                              
                                             </td>
                                    </tr>
                                     @endif 
                                    @endforeach   
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <!--End Advanced Tables -->
                </div>
            </div>
        </div>
               
    </div>
             <!-- /. PAGE INNER  -->
@endsection 
