<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\URL;
use App\Http\Controllers\Controller;
use App\Models\Approvisionnement;
use App\Models\Categorie;
use App\Models\Stock;
use App\Http\Requests;

class ApprovisionnementController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
          $table="";
        $AppNbre=Approvisionnement::where('EtatApp',0)->count();

        if ($AppNbre > 0) {

         $Approvision=Approvisionnement::where('EtatApp',0)->get();
         foreach($Approvision as $Approvi){

            $id_prod=$Approvi->Produit;
            $produit=Stock::where('id',$id_prod)->first();


            $id_cat=$produit->Categorie;
            $Categorie=Categorie::where('id',$id_cat)->first();


            $table.="
                    <tr class='odd gradeX'>
                        <td>".$produit->Produit.' '.$produit->Propriete."</td>
                         <td>".$Categorie->Categorie."</td>
                         <td>".$Approvi->Pu."</td>
                        <td>".$Approvi->Quantite."</td>
                        <td>".$Approvi->Pt."</td>
                        <td></td>
                        <td>".$Approvi->DateExpiration."</td>
                        
                        <td class='center f-icon'>
                            <form action='".route('Approv.destroy',$Approvi->id)."' method='POST'>
                            <a href='".route('Approv.edit',$Approvi->id)."'><i class='fa fa-pencil'></i></a>
                            
                                ".csrf_field()."
                                ".method_field('DELETE')."
                                <button><i class='fa fas-trash'></i>
                                    </button>
                                    
                                
                            </form>
                            
                        </td>
                      
                    </tr>";
                    }
                       # code...
        }

        $tableListe=$table;
        return view('Approv.index',compact('tableListe'));
       
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
         $produit=Stock::where('EtatStock',0)->get();
         $Categorie=Categorie::where('EtatCategorie',0)->get();
        return view('Approv.create',compact('produit', 'Categorie'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {   
        $QteStock = Stock::whereId($request->Produit)->first();
        $QteStock->quantiteStock+=$request->quantite;
          $this->validate($request,[
            'Produit'=>'required',
            'quantite'=>'required',
            'prixUnite'=>'required'
        ]);
          $prixTot=$request->quantite*$request->prixUnite;
          Approvisionnement::create([
            'Produit'=>$request->Produit,
            'Quantite'=>$request->quantite,
            'Pu'=>$request->prixUnite,
            'Pt'=>$prixTot,
            'DateExpiration'=>$request->dateExp,
            'DateCreation' => date('Y-m-d'),
            'Exercice' => date('Y'),
            'Auteur'=> session()->get('Matricule')
          ]);

          $idP=$request->Produit;
          $stck=Stock::findOrFail($idP);
          $stck->update([
            'quantiteStock'=>$QteStock->quantiteStock
          ]);
          return redirect(route('Approv.index'));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $Approv=Approvisionnement::findOrFail($id);
        $ProdApp=Stock::findOrFail($Approv->Produit);
        $produit=Stock::where('EtatStock',0)->get();
        $Categorie=Categorie::where('EtatCategorie',0)->get();
        return view('Approv.edit',compact('Approv', 'produit', 'Categorie', 'ProdApp'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $Approv=Approvisionnement::findOrFail($id);
        $QteStock = Stock::whereId($Approv->Produit)->first();
        $QteStock->quantiteStock-=$Approv->Quantite;
          $this->validate($request,[
            'Produit'=>'required',
            'quantite'=>'required',
            'prixUnite'=>'required'
        ]);
          $prixTot=$request->quantite*$request->prixUnite;
          $Approv->update([
            'Produit'=>$request->Produit,
            'Quantite'=>$request->quantite,
            'Pu'=>$request->prixUnite,
            'Pt'=>$prixTot,
            'DateExpiration'=>$request->dateExp
          ]);
          
          $QteStock->quantiteStock+=$request->quantite;

          $idP=$request->Produit;
          $stck=Stock::findOrFail($idP);
          $stck->update([
            'quantiteStock'=>$QteStock->quantiteStock
          ]);
          return redirect(route('Approv.index'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
       $Approv=Approvisionnement::findOrFail($id);
       $QteStock = Stock::whereId($Approv->Produit)->first();
       $QteStock->quantiteStock-=$Approv->Quantite;

       $Approv->update([
            'EtatApp'=>1
          ]);
          
          $QteStock->update([
            'quantiteStock'=>$QteStock->quantiteStock
          ]);
       return redirect(route('Approv.index'));
    }

    public function CorbeleAchat()
    {
         $table="";
        $AppNbre=Approvisionnement::where('EtatApp',1)->count();

        if ($AppNbre > 0) {

         $Approvision=Approvisionnement::where('EtatApp',1)->get();
         foreach($Approvision as $Approvi){

            $id_prod=$Approvi->Produit;
            $produit=Stock::where('id',$id_prod)->first();


            $id_cat=$produit->Categorie;
            $Categorie=Categorie::where('id',$id_cat)->first();


            $table.="
                    <tr class='odd gradeX'>
                        <td>".$produit->Produit.' '.$produit->Propriete."</td>
                         <td>".$Categorie->Categorie."</td>
                         <td>".$Approvi->Pu."</td>
                        <td>".$Approvi->Quantite."</td>
                        <td>".$Approvi->Pt."</td>
                        <td></td>
                        <td>".$Approvi->DateExpiration."</td>
                        
                         <td class='center f-icon'>
                            <a href='".route('restaurationAchat', $Approvi)."'><img src='".url('icons/icons8_Reset_24px.png')."' width='20px' height='20px'></a>
                        </td>
                      
                    </tr>";
                    }
                       # code...
        }

        $tableListe=$table;
        return view('Approv.CorbeleAchat',compact('tableListe'));
       
    }

    public function restaurationAchat($Achat)
    {
       $Approv=Approvisionnement::findOrFail($Achat);
       $QteStock = Stock::whereId($Approv->Produit)->first();
       $QteStock->quantiteStock+=$Approv->Quantite;

       $Approv->update([
            'EtatApp'=>0
          ]);
          
          $QteStock->update([
            'quantiteStock'=>$QteStock->quantiteStock
          ]);

          return redirect(route('CorbeleAchat'));
    }


    public function getProduit(Request $request){
        $CAT=$request->get('id_categorie');
        $produit=Stock::wherecategorieAndEtatstock($CAT,0)->get();
        $allProduit="";
        foreach ($produit as $keyProduit) {
            $allProduit.="<option value='".$keyProduit->id."'>".$keyProduit->Produit.' '.$keyProduit->Propriete."</option>";
        }
        echo $allProduit;

    }

        public function research(Request $request){
        $CAT=$request->get('produit');
        $idCat=$request->get('id_categorie');
        $produit=Stock::where('Produit','like','%'.$CAT.'%')->where('Categorie',$idCat)->get();
        $allProduit="";
        foreach ($produit as $keyProduit) {
            $allProduit.="<option value='".$keyProduit->id."'>".$keyProduit->Produit.' '.$keyProduit->Propriete."</option>";
        }
        echo $allProduit;
    }
}
