<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Models\Approvisionnement;
use App\Models\Commande;
use App\Models\Exclusion;
use App\Models\Facture;
use App\Models\Stock;
use App\Models\Categorie;
use App\Models\Client;

class ArchiveController extends Controller
{
   public function ArchiveAchat()
   {
      $Achats = Approvisionnement::whereEtatapp('!=1')->groupBy('Exercice')->get();
      $Commandes = Commande::whereEtatcommande('!=1')->groupBy('Exercice')->get();
      $Exclusions = Exclusion::whereEtat('!=1')->groupBy('Exercice')->get();
      $Factures = Facture::whereEtatfacture(1)->groupBy('Exercice')->get();

      //Tableau de Bord

       $CurentYear = date('Y');
        $NbreVente = Commande::whereEtatcommandeAndExercice('!=1',$CurentYear-1)->count('id');
        $MontantVente = Commande::whereEtatcommandeAndExercice('!=1',$CurentYear-1)->sum('Montant');

        $NbreAchat = Approvisionnement::whereEtatappAndExercice('!=1',$CurentYear-1)->count('id');
        $MontantAchat = Approvisionnement::whereEtatappAndExercice('!=1',$CurentYear-1)->sum('Pt');

        $NbreFacture = Facture::whereEtatfactureAndExercice('!=1',$CurentYear-1)->count('id');
        $MontantFacture = Facture::whereEtatfactureAndExercice('!=1',$CurentYear-1)->sum('Mtvac');

        $NbreExclusion = Exclusion::whereEtatAndExercice('!=1',$CurentYear-1)->count('id');
        $MontantExclusion = Exclusion::whereEtatAndExercice('!=1',$CurentYear-1)->sum('Montant');
                             
      return view('Archives.Archive', compact('Achats', 'Commandes', 'Exclusions', 'Factures', 'NbreVente', 'MontantVente', 'NbreAchat', 'MontantAchat', 'NbreFacture', 'MontantFacture', 'NbreExclusion', 'MontantExclusion'));
   }


   public function ArchiveAnnuelAchat($Exercice)
   {
   	 
     $table="";
        $AppNbre=Approvisionnement::whereEtatappAndExercice('!=1',$Exercice)->count();

        if ($AppNbre > 0) {

         $Approvision = Approvisionnement::whereEtatappAndExercice('!=1',$Exercice)->get();
         foreach($Approvision as $Approvi){

            $id_prod=$Approvi->Produit;
            $produit=Stock::where('id',$id_prod)->first();


            $id_cat=$produit->Categorie;
            $Categorie=Categorie::where('id',$id_cat)->first();


            $table.="
                    <tr class='odd gradeX'>
                        <td>".$produit->Produit."</td>
                        <td>".$Categorie->Categorie."</td>
                         <td>".$Approvi->Pu."</td>
                        <td>".$Approvi->Quantite."</td>
                        <td>".$Approvi->Pt."</td>
                        <td></td>
                        <td>".$Approvi->DateExpiration."</td>
                        <td>
                        <form action='".route('Approv.destroy',$Approvi->id)."' method='POST'>
                            <a href='".route('Approv.edit',$Approvi->id)."'><i class='fa fa-pencil'></i></a>
                            
                                ".csrf_field()."
                                ".method_field('DELETE')."
                                <button><i class='fa fas-trash'></i>
                                    </button>
                                    
                                
                            </form> 
                        </td>
                    </tr>
                    ";
                    }
                       # code...
        }

        $tableListe=$table;

     $Achats = Approvisionnement::whereEtatapp('!=1')->groupBy('Exercice')->get();
      $Commandes = Commande::whereEtatcommande('!=1')->groupBy('Exercice')->get();
      $Exclusions = Exclusion::whereEtat('!=1')->groupBy('Exercice')->get();
      $Factures = Facture::whereEtatfacture(1)->groupBy('Exercice')->get();   
     $MontantAchat = Approvisionnement::whereEtatappAndExercice('!=1',$Exercice)->sum('Pt');

     return view('Archives.ArchiveAnnuelAchat', compact('tableListe', 'MontantAchat', 'Achats', 'Commandes', 'Exclusions', 'Factures', 'Exercice'));
   }


   public function ArchiveAnnuelVente($Exercice)
   {
   	 
     $Ventes = Commande::whereEtatcommandeAndExercice('!=1',$Exercice);
     $Achats = Approvisionnement::whereEtatapp('!=1')->groupBy('Exercice')->get();
      $Commandes = Commande::whereEtatcommande('!=1')->groupBy('Exercice')->get();
      $Exclusions = Exclusion::whereEtat('!=1')->groupBy('Exercice')->get();
      $Factures = Facture::whereEtatfacture(1)->groupBy('Exercice')->get();   
      $MontantVente = Commande::whereEtatcommandeAndExercice('!=1',$Exercice)->sum('Montant');


     return view('Archives.ArchiveAnnuelVente', compact('Ventes', 'MontantVente', 'Achats', 'Commandes', 'Exclusions', 'Factures', 'Exercice'));
   }

   public function ArchiveAnnuelExclusion($Exercice)
   {
     $table="";
     $Exclusions = Exclusion::whereEtatAndExercice('!=1', $Exercice)->get();

         foreach($Exclusions as $Exclusion)
         {
            $id_Produit=$Exclusion->Produit;
            $Produit=Stock::where('id',$id_Produit)->first();
            $table.="
                    <tr class='odd gradeX' style='height:20px;'>
                        <td>".$Produit->Produit.' '.$Produit->Propriete."</td>
                        <td>".$Exclusion->Quantite."</td>
                        <td>".$Exclusion->Montant."</td>
                        <td>".$Exclusion->Motif."</td>
                       <td>".$Exclusion->DateExclusion."</td>
                        
                        <td class='center f-icon'>
                            <form action='".route('Exclusions.destroy',$Exclusion)."' method='POST'>
                            <a href='".route('Exclusions.edit',$Exclusion)."'><i class='fa fa-pencil'></i></a>
                            
                                ".csrf_field()."
                                ".method_field('DELETE')."
                                <button><i class='fa fas-trash'></i>
                                    </button>
                            </form>
                        </td>
                      
                    </tr>";
                    }


        $tableListe=$table;
        
     //$Ventes = Commande::whereEtatcommandeAndExercice('!=1',$Exercice);
     $Achats = Approvisionnement::whereEtatapp('!=1')->groupBy('Exercice')->get();
      $Commandes = Commande::whereEtatcommande('!=1')->groupBy('Exercice')->get();
      $Exclusions = Exclusion::whereEtat('!=1')->groupBy('Exercice')->get();
      $Factures = Facture::whereEtatfacture(1)->groupBy('Exercice')->get();   
      $MontantExclusion = Exclusion::whereEtatAndExercice('!=1',$Exercice)->sum('Montant');


     return view('Archives.ArchiveAnnuelExclusion', compact('MontantExclusion', 'Achats', 'Commandes', 'Exclusions', 'Factures', 'Exercice', 'tableListe'));
   }

   public function ArchiveAnnuelFacture($Exercice)
   {
     $table="";
     $Factures = Facture::whereEtatfactureAndExercice(1, $Exercice)->get();

         foreach($Factures as $Facture)
         {
            $id_Client=$Facture->idClient;
            $Client=Client::where('id',$id_Client)->first();
            $table.="
                    <tr class='odd gradeX' style='height:20px;'>
                        <td>".$Facture->Code."</td>
                        <td>".$Client->Nom."</td>
                        <td>".$Facture->Auteur."</td>
                        <td>".$Facture->Mhtva."</td>
                        <td>".$Facture->Mtvac."</td>
                       <td>".$Facture->DateCreation."</td>
                        
                        <td class='center f-icon'>
                            Annee Cloturée
                        </td>
                      
                    </tr>";
                    }

        $tableListe=$table;
        
     //$Ventes = Commande::whereEtatcommandeAndExercice('!=1',$Exercice);
     $Achats = Approvisionnement::whereEtatapp('!=1')->groupBy('Exercice')->get();
      $Commandes = Commande::whereEtatcommande('!=1')->groupBy('Exercice')->get();
      $Exclusions = Exclusion::whereEtat('!=1')->groupBy('Exercice')->get();
      $Factures = Facture::whereEtatfacture(1)->groupBy('Exercice')->get();   
      $MontantFacture = Facture::whereEtatfactureAndExercice(1,$Exercice)->sum('Mtvac');


     return view('Archives.ArchiveAnnuelFacture', compact('MontantFacture', 'Achats', 'Commandes', 'Exclusions', 'Factures', 'Exercice', 'tableListe'));
   }

       public function graphicA(){
              $CurentYear = date('Y');
              $comm = DB::table('commandes')
                     ->select(DB::raw('sum(Quantite) as quant_sup, sum(Montant) as MontantSup, Produit'))
                     ->whereExercice($CurentYear-1)
                     ->groupBy('Produit')
                     ->orderBy('quant_sup','desc')
                     ->limit(5)
                     ->get();
            $graph="";
            foreach ($comm as $keyComme) {
                $NomP = Stock::findOrFail($keyComme->Produit);
                $graph.=$NomP->Produit.' '.$NomP->Propriete."#";
                $graph.=$keyComme->quant_sup."#";
                 $graph.=$keyComme->MontantSup."#";
            }

            echo $graph;
    }
}
