<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Models\Facture;
use Illuminate\Support\Facades\DB;
use App\Interfaces\IArticle as IArticle;
use App\Models\Article;
use App\Interfaces\ICategorie as ICategorie;
use App\Models\Categorie;
use App\Interfaces\ITaxe as ITaxe;
use App\Models\Taxe;
use PDF;
class ArticleController extends Controller
{   
    
    public function __construct(IArticle $Article, ICategorie $Categorie, ITaxe $Taxe){
        $this->Article = $Article;
        $this->Categorie = $Categorie;
        $this->Taxe = $Taxe;
        $this->middleware('guest');
      }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $results = $this->Article->showitems();
        $categories = $this->Categorie->showitems();
        $taxes = $this->Taxe->showitems();
        return view('Articles/index', compact('results', 'categories', 'taxes'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->Article->savedata($request, null);
        return redirect(route('Article.index'));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $this->Article->showitem($id);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
         $this->Article->savedata($request, $id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $this->Article->deletedata($id);
    }

    public function getArticleInformation(Request $request){
        $Article=$request->get('Article');
        $Articles=$this->Article::whereId($Article)->get();
        $allArticles="";
        foreach ($Articles as $Article) {
            $allArticles=$Article->Taxe.'#'.$Article->Coutachat.'#'.$Article->Unitemesure;
           
        }
        echo $allArticles;
    }
}
