<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Models\Categorie;
use App\Interfaces\ICategorie as ICategorie;
class CategorieController extends Controller
{
     public function __construct(ICategorie $Categorie){
        $this->Categorie = $Categorie;
        $this->middleware('guest');
      }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $results = $this->Categorie->showitems();
        return view('Categories.index',compact('results'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('Categories.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
       
       $this->Categorie->savedata($request, null);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        dd('BONJOUR ');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $categorie=Categorie::findOrFail($id);
        return view('Categories.edit',compact('categorie'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request,[
            'cate'=>'required'
        ]);
        $verification=Categorie::whereCategorie($request->cate)->count('id');
        if ($verification==0) {
            # code...
        
        $categ=Categorie::findOrFail($id);
        $categ->update([
            'Categorie'=> $request->cate,
            'Auteur' =>2
            ]);
       return redirect(route('Categories.index'));
       }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $cat=Categorie::findOrFail($id);
        $cat->update(['EtatCategorie'=>1]);
        return redirect(route('Categories.index'));
    }

    public function CorbeleCategorie()
    {
       $Categories=Categorie::where('EtatCategorie',1)->get();
        return view('Categories.CorbeleCategorie',compact('Categories'));
    }

    public function restaurationCategorie($Categorie)
    {
      $cat=Categorie::findOrFail($Categorie);
      $cat->update(['EtatCategorie'=>0]);
      return redirect(route('CorbeleCategorie'));  
    }
}
