<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Models\Client;
use App\Models\Stock;
use App\Models\Facture;
use App\Models\Commande;
use App\Interfaces\IClient as IClient;

class ClientController extends Controller
{
    public function __construct(IClient $Client){
        $this->Client = $Client;
        $this->middleware('guest');
      }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $results = $this->Client->showitems();
        return view('Clients.index', compact('results'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('Clients.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {   
       $this->Client->savedata($request, null);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {   
        $NvlleF = Facture::whereIdclientAndAuteurAndEtatfacture($id,'1','0')->max('id');
        $a = $NvlleF;
        $Commandes = Commande::whereFacture($a)->paginate(5);
        $MontantT = Commande::whereFactureAndEtatcommande($a,'!=1')->sum('Montant');
        //Remplire le combobox des produits
        $Stocks = Stock::whereEtatstock('!=1')->get();
        $Client = Client::findOrFail($id);
        return view('Clients.show', compact('Stocks', 'Commandes', 'MontantT', 'Client', 'a'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {   
        $Client = Client::findOrFail($id);
        return view('Clients.edit', compact('Client'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
        'Nom' => 'required|max:50', 
        'Telephone' => 'required|min:7|max:15',
        'Email' => 'E-Mail',
        'Adresse' => 'required|max:50',
        'Categorie' => 'required',
        'Situation' => 'required'
        ]); 

        $Client = Client::findOrFail($id);
        $Client->update([
            'Nom' => $request->Nom,
            'Telephone' => $request->Telephone,
            'Email' => $request->Email,
            'Adresse' => $request->Adresse,
            'Categorie' => $request->Categorie,
            'Assujetti' => $request->Situation
        ]);
        session()->flash('message', 'Client Modifier avec success!');
        $Clients = Client::whereEtatclient('!=1')->paginate(15);
        return redirect( route('Clients.index',compact('Clients')));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
       $Client = Client::findOrFail($id);
       $Client->update(['EtatClient' => 1]);

        session()->flash('messageDelete', 'Le Client a ete Supprimé avec success!');
        $Clients = Client::whereEtatclient('!=1')->paginate(15);
        return redirect( route('Clients.index',compact('Clients')));
    }

    public function CorbeleClient()
    {
        $Clients = Client::whereEtatclient(1)->get();
        return view('Clients.CorbeleClient', compact('Clients'));
    }

    public function restaurationClient($Client)
    {
       $Client = Client::findOrFail($Client);
       $Client->update(['EtatClient' => 0]);

        session()->flash('message', 'Le Client a ete Restauré avec success!');
        $Clients = Client::whereEtatclient('!=1')->paginate(15);
        return redirect( route('CorbeleClient'));
    }
}
