<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Models\Commande;
use App\Models\Facture;
use App\Models\Stock;
use App\Models\Client;
use App\Models\Categorie;
use App\Models\TypeVente;
use App\Models\ProduitUniteVente;
use App\Interfaces\ICommande as ICommande;
use App\Interfaces\IFournisseur as IFournisseur;
use App\Interfaces\ISite as ISite;
use App\Interfaces\ITaxe as ITaxe;
use App\Interfaces\ITransporteur as ITransporteur;
use App\Interfaces\IArticle as IArticle;
use App\Interfaces\IArticlecommander as IArticlecommander;
use DB;
class CommandeController extends Controller
{

   public function __construct(ICommande $Commande, IFournisseur $Fournisseur, ISite $Site, ITaxe $Taxe, ITransporteur $Transporteur, IArticle $Article, IArticlecommander $Articlecommander){
        $this->Commande = $Commande;
        $this->Fournisseur = $Fournisseur;
        $this->Site = $Site;
        $this->Taxe = $Taxe;
        $this->Transporteur = $Transporteur;
        $this->Article = $Article;
        $this->Articlecommander = $Articlecommander;
        $this->middleware('guest');
      }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $results = $this->Commande->showitems();
        return view('Commandes.index', compact('results'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {   
        $Fournisseurs = $this->Fournisseur->showitems();
        $Taxes = $this->Taxe->showitems();
        $Sites = $this->Site->showitems();
        $Transporteurs = $this->Transporteur->showitems();
        $Articles = $this->Article->showitems();
        $OrderingSum =$this->Articlecommander::whereCommandeidAndEtat(0,0)->sum('Totalunitaire');
        $Articleordering =$this->Articlecommander->articleordering(); 
        $TVA=0;
     
        $OderNbre = DB::table('commandes')
                        ->join('fournisseurs', 'fournisseurs.id', '=', 'commandes.Fournisseurid')
                        ->join('sites', 'sites.id', '=', 'commandes.Site')
                        ->join('transporteurs', 'transporteurs.id', '=', 'commandes.Transporteur')
                        ->select(DB::raw('fournisseurs.id as Fid, sites.id as Sid, fournisseurs.Nom as Fnom, sites.Nom as Snom, transporteurs.id as Trid, transporteurs.Transporteur as Trnom, commandes.Datereceptionprevue, commandes.Adressefacturation, commandes.Numerorefsuivi, commandes.Dateemission, commandes.Notedelacommande, commandes.Noteinterne, commandes.Soustotal, commandes.Taxetotal'))
                        ->where('commandes.Etat',0)
                        ->where('commandes.Statut', 0)
                        ->where('commandes.Auteur', session()->get('Matricule'))
                        ->count('commandes.id'); 

        if ($OderNbre>0) {

             $Orderingdata = DB::table('commandes')
                        ->join('fournisseurs', 'fournisseurs.id', '=', 'commandes.Fournisseurid')
                        ->join('sites', 'sites.id', '=', 'commandes.Site')
                        ->join('transporteurs', 'transporteurs.id', '=', 'commandes.Transporteur')
                        ->select(DB::raw('fournisseurs.id as Fid, sites.id as Sid, fournisseurs.Nom as Fnom, sites.Nom as Snom, transporteurs.id as Trid, transporteurs.Transporteur as Trnom, commandes.Datereceptionprevue, commandes.Adressefacturation, commandes.Numerorefsuivi, commandes.Dateemission, commandes.Notedelacommande, commandes.Noteinterne, commandes.Soustotal, commandes.Taxetotal, commandes.Destinataire, commandes.Taxe as Ctaxe'))
                        ->where('commandes.Etat',0)
                        ->where('commandes.Statut', 0)
                        ->where('commandes.Auteur', session()->get('Matricule'))
                        ->first(); 

          if($Orderingdata->Ctaxe==1){

            foreach($Articleordering as $Artord){

                if($Artord->Taxe==0){
                    $DT = $this->Taxe->findDefaultTaxe();
                    $TVA += (($DT->Montant*$Artord->Totalunitaire)/100); 
                    
                }else{
                    $DT = $this->Taxe->showitem($Artord->Taxe);
                    $TVA += (($DT->Montant*$Artord->Totalunitaire)/100); 
                   
                }
            }
              $ST = $OrderingSum-$TVA;
          }else{
             $TVA=0;
             $ST = $OrderingSum;
          }             
        } 

       
                      
        return view('Commandes.create', compact('Fournisseurs', 'Taxes', 'Sites', 'Transporteurs', 'Articles', 'Orderingdata', 'OderNbre', 'Articleordering', 'OrderingSum', 'TVA', 'ST'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    { 
        if(isset($request->AjouterArticle)){
           
           $this->Commande->savedata($request, null);
           $this->Articlecommander->savedata($request, null);

        }elseif(isset($request->Enregistrer)){
           $R = $this->Commande->SavingOrder();
           $this->Articlecommander->AttributeArticleToOrder($R);
           $this->Commande->EndingOrdering($R);
           $this->Commande->savedata($request, $R);
        }  
      

      return redirect(route('Commandes.create'));
    }
 
    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
     
     $Client = Client::findOrFail($id);
     
     $FactureNbre=Facture::whereIdclientAndEtatfacture($id, 0)->count();
     if ($FactureNbre > 0) 
     {
        $Facture = Facture::whereIdclientAndEtatfacture($id, 0)->first();
        $Commandes = Commande::whereFacture($Facture->id)->paginate(5);
        $MontantT = Commande::whereFactureAndEtatcommande($Facture->id, '!=1')->sum('Montant');
      }
      else
      {
        $MontantT = 0;
        $Commandes = [];
      }
     $UniteVentes = TypeVente::whereEtat('!=1')->get();  
     $Stocks = Stock::whereEtatstock('!=1')->get();
     $Categories = Categorie::whereEtatcategorie('!=1')->get();
     $aNbre=Facture::whereIdclientAndEtatfacture($id, 1)->count();
     $NbreFactureNv=Facture::whereIdclientAndEtatfacture($id, 0)->count();
     if ($aNbre > 0) 
     {
       $a = Facture::whereIdclientAndEtatfacture($id, 1)->max('id');
     }
     else
     {
      $a = 0;
     }  
     
      $table="";
        $StockVar=Stock::where('EtatStock',0)->get();

         foreach($Commandes as $Commande){

            $Produit=$Commande->Produit;
            $ProdDetail=Stock::where('id',$Produit)->first();

            $UniteVente=$Commande->UniteVente;
            $UniteVenteDetail=TypeVente::where('id',$UniteVente)->first();
            $table.="
                    <tr class='odd gradeX' style='height:20px;'>
                        <td>".$ProdDetail->Produit.' '.$ProdDetail->Propriete."</td>

                        <td>".$UniteVenteDetail->TypeVente."</td>
                        <td>".$Commande->Quantite."</td>
                        <td>".$Commande->Montant."</td>                        
                        <td class='center f-icon'>

                            <form action='".route('Commandes.destroy', $Commande)."' method='POST'>

                            <a href='".route('Commandes.edit', $Commande)."'><i class='fa fa-pencil'></i></a>
                            
                                ".csrf_field()."
                                ".method_field('DELETE')."
                                <button><i class='fa fas-trash'></i>
                                    </button>
                            </form>
                        </td>
                      
                    </tr>";
                    }
        $tableListe=$table;
        // return view('Stock.index',compact('tableListe'));
     return view('Commandes.show', compact('Client', 'Commandes', 'Stocks', 'MontantT', 'a', 'Categories', 'UniteVentes', 'tableListe','NbreFactureNv'));  
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {

     $Commande = Commande::findOrFail($id);
     $TypeVente = TypeVente::findOrFail($Commande->UniteVente);  
     $Stock = Stock::findOrFail($Commande->Produit);

     $UniteVentes = TypeVente::whereEtat('!=1')->get();  
     $Stocks = Stock::whereEtatstock('!=1')->get();

     $Categories = Categorie::whereEtatcategorie('!=1')->get();
     $aNbre=Facture::whereIdclientAndEtatfacture($id, 1)->count();
     return view('Commandes.edit', compact('Stocks', 'MontantT', 'a', 'Categories', 'UniteVentes', 'Commande', 'Stock', 'TypeVente'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
        'Quantite' => 'required|Numeric'
        ]); 
        
        // Conversion de la qte Commande En pieces
        $QteDemande = $request->Quantite;
        $QteUV = ProduitUniteVente::whereProduitAndTypevente($request->Produit,$request->TypeVente)->first();
        $request->Quantite *= $QteUV->Qte;

         //Trouver le Montant Totale A Payer
         $PrixProduit = ProduitUniteVente::whereProduitAndTypevente($request->Produit,$request->TypeVente)->first();
         $Totale =$QteDemande * $PrixProduit->PU;
        //Remise de la Qte demandee en Stock
        $Commande = Commande::findOrFail($id);
        $Facture = Facture::findOrFail($Commande->Facture);
        $Stock = stock::findOrFail($Commande->Produit);

        // Conversion de la qte Commande En pieces
        //$QteDemande = $request->Quantite;
        // $QteUV = ProduitUniteVente::whereProduitAndTypevente($Commande->Produit,$Commande->UniteVente)->first();
        // $Commande->Quantite *= $QteUV->Qte;

        $Stock->quantiteStock+=$Commande->QtePiece;
        $Stock->update(['quantiteStock' => $Stock->quantiteStock]);

        //Modifiacation de la Commande
        $Commande->update([
            'Quantite' => $QteDemande,
            'QtePiece' => $request->Quantite,
            'Produit' => $request->Produit,
            'UniteVente' => $request->TypeVente,
            'Montant' => $Totale
        ]);
    
        //Calcule de la somme hors tva 
        $SommeThtva = Commande::whereFactureAndEtatcommande($Commande->Facture, '!=1')->sum('Montant');
        //Calcule de la somme avec tva
        $SommeTtvac = ($SommeThtva+(($SommeThtva*18)/100));
        //Modifiacation de la Facture
        $Facture->update(['Mhtva' => $SommeThtva, 'Mtvac' => $SommeTtvac]);    

        //Retranche de la Qte demande en stock
        //La Qte en Stock du produit commande
        $QsteStock = stock::findOrFail($request->Produit);

        // Conversion de la qte Commande En pieces
        //$QteDemande = $request->Quantite;
        $QteUV = ProduitUniteVente::whereProduitAndTypevente($request->Produit,$request->TypeVente)->first();
        $QteDemande *= $QteUV->Qte;

        $QsteStock->quantiteStock -= $request->Quantite;

        //Mis a Jour de la Qte en stock
        $QsteUpdate  = Stock::findOrFail($request->Produit);
        $QsteUpdate->update([
        'quantiteStock' => $QsteStock->quantiteStock
        ]);   

     $MontantT = Commande::whereFactureAndEtatcommande($Commande->Facture, '!=1')->sum('Montant');
     //Remplire le combobox des produits
     // $UniteVentes = TypeVente::whereEtat('!=1')->get();
     // $Stocks = Stock::whereEtatstock('!=1')->get();
     // $Categories = Categorie::whereEtatcategorie('!=1')->get();
     $ClientCode = Facture::findOrFail($Commande->Facture);
     $Client = Client::findOrFail($ClientCode->idClient);
     //$Commandes = Commande::whereFacture($Commande->Facture)->paginate(5);
     // return view('Clients.show',compact('Commandes', 'MontantT','Client', 'Stocks', 'Categories', 'UniteVentes'));

     return redirect(route('Commandes.show',compact('Client'))); 
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {  
        //On Change L'etat de la commande
        $Commande = Commande::findOrFail($id);
        $Facture = Facture::findOrFail($Commande->Facture);
        $Commande->update([
            'EtatCommande' => 1
        ]);
     
        //Calcule de la somme hors tva 
        $SommeThtva = Commande::whereFactureAndEtatcommande($Commande->Facture, '!=1')->sum('Montant');
        //Calcule de la somme avec tva
        $SommeTtvac = ($SommeThtva+(($SommeThtva*18)/100));
        //Modifiacation de la Facture
        $Facture->update(['Mhtva' => $SommeThtva, 'Mtvac' => $SommeTtvac]);    

        //Ajout de Qte du Stock 
        //La Qte en Stock du produit commande
        $QsteStock = stock::findOrFail($Commande->Produit);
        $QsteStock->quantiteStock += $Commande->QtePiece;

        //Mis a Jour de la Qte en stock
        $QsteUpdate  = Stock::findOrFail($Commande->Produit);
        $QsteUpdate->update([
        'quantiteStock' => $QsteStock->quantiteStock
        ]);   

     $MontantT = Commande::whereFactureAndEtatcommande($Commande->Facture, '!=1')->sum('Montant');
     //Remplire le combobox des produits
     $UniteVentes = TypeVente::whereEtat('!=1')->get();
     $Stocks = Stock::whereEtatstock('!=1')->get();
     $Categories = Categorie::whereEtatcategorie('!=1')->get();
     $ClientCode = Facture::findOrFail($Commande->Facture);
     $Client = Client::findOrFail($ClientCode->idClient);
     $Commandes = Commande::whereFacture($Commande->Facture)->paginate(5);
     // return view('Clients.show',compact('Commandes', 'MontantT','Client', 'Stocks', 'Categories', 'UniteVentes'));
     return redirect(route('Commandes.show',compact('Client')));
    }


   //AFFICHAGE DE COMMANDES EN CORBEILLE
    public function CorbeleVente()
    {
      $Commandes = Commande::whereEtatcommande(1)->get();
      return view('Commandes.CorbeleVente', compact('Commandes'));
    }


    public function restauration($id)
    {
       //On Change L'etat de la commande
        $Commande = Commande::findOrFail($id);
        $Facture = Facture::findOrFail($Commande->Facture);
        $Commande->update([
            'EtatCommande' => 0
        ]);
     
        //Calcule de la somme hors tva 
        $SommeThtva = Commande::whereFactureAndEtatcommande($Commande->Facture, '!=1')->sum('Montant');
        //Calcule de la somme avec tva
        $SommeTtvac = ($SommeThtva+(($SommeThtva*18)/100));
        //Modifiacation de la Facture
        $Facture->update(['Mhtva' => $SommeThtva, 'Mtvac' => $SommeTtvac]);    

        //Ajout de Qte du Stock 
        //La Qte en Stock du produit commande
        $QsteStock = stock::findOrFail($Commande->Produit);
        $QsteStock->quantiteStock -= $Commande->QtePiece;

        //Mis a Jour de la Qte en stock
        $QsteUpdate  = Stock::findOrFail($Commande->Produit);
        $QsteUpdate->update([
        'quantiteStock' => $QsteStock->quantiteStock
        ]);   

     return redirect(route('CorbeleVente'));
    }


     public function getProduitCommande(Request $request){
        $CAT=$request->get('id_categorie');
        $produit=Stock::wherecategorieAndEtatstock($CAT,0)->get();
        $allProduit="<option selected='selected'>Selection unite vente</option>";
        foreach ($produit as $keyProduit) {
            $allProduit.="<option value='".$keyProduit->id."'>".$keyProduit->Produit.' '.$keyProduit->Propriete."</option>";
        }
        echo $allProduit;

    }

        public function getTypeVente(Request $request){
        $prod=$request->get('idProduit');
        $produit=ProduitUniteVente::where('Produit',$prod)->get();
        $allProduit="";
        foreach ($produit as $keyProduit) {
            $typevend=TypeVente::whereIdAndEtat($keyProduit->TypeVente,0)->first();
            $allProduit.="<option value='".$typevend->id."'>".$typevend->TypeVente."</option>";
        }
        echo $allProduit;

    }
}
