<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Models\Facture;
use App\Models\Commande;
use App\Models\Stock;
use App\Models\TypeVente;
use PDF;
use DB;

class FactureController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
       $Factures = Facture::whereEtatfacture(1)->get();
       return view('Factures.index', compact('Factures'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
       $Facture = Facture::findOrFail($id);
       $Facture->update([
            'EtatFacture' => 2
        ]);

     $Factures = Facture::paginate(15);
     return redirect(route('Factures.index'));
    }

    public function restauration($id)
    {
       $Facture = Facture::findOrFail($id);
       $Facture->update([
            'EtatFacture' => 1
        ]);

     $Factures = Facture::paginate(15);
     return redirect(route('CorbeleFacture'));
    }

    public function CorbeleFacture()
    {
       $Factures = Facture::whereEtatfacture(2)->get();
       return view('Factures.CorbeleFacture', compact('Factures'));
    }

    public function pdfexport($id)
    {

       $Facture = Facture::findOrFail($id);
       $Commandes = Commande::whereFacture($id)->get();
       $TotalP = Commande::whereFacture($id)->sum('Montant');

       $table="";
         foreach($Commandes as $Commande){
            $id_Pro=$Commande->Produit;
            $Produit=Stock::where('id',$id_Pro)->first();

            $id_TypeVente=$Commande->UniteVente;
            $TypeVente=TypeVente::findOrFail($id_TypeVente);

            $table.="
                    <tbody>
                    <tr class='odd gradeX' style='height:20px;'>
                        <td>".$Produit->Produit.' '.$Produit->Propriete."</td>
                        <td>".$TypeVente->TypeVente."</td>
                        <td>".$Commande->Quantite."</td>
                        <td>".$Commande->Montant."</td>
                    </tr>
                    </tbody>
                    ";
                    }


        $tableListe=$table;
      //$Facture = Facture::find($id);
      $pdf = PDF::loadView('Factures.pdf', compact('Facture', 'tableListe', 'TotalP'))->setPaper('a5', 'portrait');
      $fileName = $Facture->name;
      return $pdf->stream($fileName . '.pdf');
    }
}
