<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Models\ProduitUniteVente;
use App\Models\TypeVente;
use App\Models\Stock;
use App\Models\Categorie;

class ProduitUniteVenteController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
        'TypeVente' => 'required', 
        'Qte' => 'required',
        // 'QteMin' => 'required',
        'PU' => 'required',
        'Produit' => 'required'
        ]);

        $NbreUv = ProduitUniteVente::whereTypeventeAndProduit($request->TypeVente,$request->Produit)->count();

        // $VerifierInter = ProduitUniteVente::whereProduitAndQtemnAndQtemax($request->Produit,'>=request->QteMin','<=request->QteMax')->count(); 
       // if ($VerifierInter == 0) 
       // {
       
        if ($NbreUv == 0) 
        {
          ProduitUniteVente::create([
            'Produit' => $request->Produit,
            'TypeVente' => $request->TypeVente,
            'PU' => $request->PU,
            'Qte' => $request->Qte,
            // 'QteMn' => $request->QteMin,
            'Auteur' => session()->get('Matricule')
        ]);
        
        session()->flash('message', 'Affectation faite avec success!');
        }
        else
        {
          session()->flash('messageDelete', 'Cet Unite de vente existe pour ce Produit!');
        }
       // }
       // else
       // {
       //   session()->flash('messageDelete', 'Cet Intervalle est deja Utilise');
       // } 
        $Stock = $request->TypeVente;
        return redirect( route('TypeVentes.show', compact('Stock')));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {  
       $PUV = ProduitUniteVente::findOrFail($id);
       $TypeVente = TypeVente::findOrFail($PUV->TypeVente);
       $Categories = Categorie::whereEtatcategorie('!=1')->get();
       $StockP = Stock::findOrFail($PUV->Produit);
       $Stocks = Stock::whereEtatstock('!=1')->get(); 
       return view('ProduitUniteVentes.edit', compact('TypeVente', 'Categories', 'StockP', 'Stocks', 'PUV'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
       $this->validate($request, [
        'TypeVente' => 'required', 
        'PU' => 'required',
        'Produit' => 'required'
        ]);

        $NbreUv = ProduitUniteVente::where('Typevente',$request->TypeVente)->where('Produit',$request->Produit)->where('Id','!=',$id)->count();

        // $VerifierInter = ProduitUniteVente::whereProduitAndQtemnAndQtemax($request->Produit,'>=request->QteMin','<=request->QteMax')->count(); 
       // if ($VerifierInter == 0) 
       // {

        $PUV = ProduitUniteVente::findOrFail($id);
       
        if ($NbreUv == 0) 
        {
          $PUV->update([
            'Produit' => $request->Produit,
            'TypeVente' => $request->TypeVente,
            'PU' => $request->PU
        ]);
        
        session()->flash('message', 'Affectation faite avec success!');
        }
        else
        {
          session()->flash('messageDelete', 'Cet Unite de vente existe pour ce Produit!');
        }
        $Stock = $request->TypeVente;
        return redirect( route('TypeVentes.show', compact('Stock')));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $PUV = ProduitUniteVente::findOrFail($id);
        $TypeVente = TypeVente::findOrFail($PUV->TypeVente);
        $PUV->update([
            'Etat' => 1
        ]);
        session()->flash('messageDelete', 'Affectation supprimée avec success!');
        $Stock = $TypeVente;
        return redirect( route('TypeVentes.show', compact('Stock')));
    }

    public function CorbelePUV()
    {
      $ProduitUniteVentes = ProduitUniteVente::whereEtat(1)->get();
      $table="";
        
         foreach($ProduitUniteVentes as $ProduitUniteVente){

            $id_prod=$ProduitUniteVente->Produit;
            $produit=Stock::where('id',$id_prod)->first();


            $id_TypeVente=$ProduitUniteVente->TypeVente;
            $TypeVente=TypeVente::where('id',$id_TypeVente)->first();


            $table.="
                    <tr class='odd gradeX'>
                        <td>".$produit->Produit.' '.$produit->Propriete."</td>
                         <td>".$TypeVente->TypeVente."</td>
                         <td>".$ProduitUniteVente->PU."</td>
                        <td>".$ProduitUniteVente->created_at."</td>
                        
                        <td class='center f-icon'>
                            <a href='".route('restaurationPUV', $ProduitUniteVente)."'><img src='".url('icons/icons8_Reset_24px.png')."' width='20px' height='20px'></a>
                                    
                                
                            </form>
                            
                        </td>
                      
                    </tr>";
                       # code...
        }

        $tableListe=$table;
        return view('ProduitUniteVentes.CorbelePUV', compact('tableListe'));
    }

    public function restaurationPUV($PUV)
    {
        $PUV = ProduitUniteVente::findOrFail($PUV);
        $PUV->update([
            'Etat' => 0
        ]);
        session()->flash('message', 'Affectation Restaurée avec success!');
        return redirect(route('CorbelePUV'));
    }

    public function getProduit(Request $request){
        $CAT=$request->get('id_categorie');
        $produit=Stock::wherecategorieAndEtatstock($CAT,0)->get();
        $allProduit="";
        foreach ($produit as $keyProduit) {
            $allProduit.="<option value='".$keyProduit->id."'>".$keyProduit->Produit.' '.$keyProduit->Propriete."</option>";
        }
        echo $allProduit;

    }

        public function research(Request $request){
        $CAT=$request->get('produit');
        $idCat=$request->get('id_categorie');
        $produit=Stock::where('Produit','like','%'.$CAT.'%')->where('Categorie',$idCat)->get();
        $allProduit="";
        foreach ($produit as $keyProduit) {
            $allProduit.="<option value='".$keyProduit->id."'>".$keyProduit->Produit.' '.$keyProduit->Propriete."</option>";
        }
        echo $allProduit;

    }

}
