<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Models\Stock;
use App\Models\Categorie;
use App\Models\Approvisionnement;
use App\Models\Commande;
use App\Models\ProduitUniteVente;
use App\Models\TypeVente;
use App\Models\Exclusion;

use App\Interfaces\IStock as IStock;
use App\Models\Site;
use App\Interfaces\ISite as ISite;

use App\Models\Article;
use App\Interfaces\IArticle as IArticle;

class StockController extends Controller
{

    public function __construct(IStock $Stock, ISite $Site, IArticle $Article){
        $this->Stock = $Stock;
        $this->Site = $Site;
        $this->Article = $Article;
        $this->middleware('guest');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
     public function index()
     {  
        $results = $this->Stock->showitems();
        $Sites = $this->Site->showitems();
        $Articles = $this->Article->showitems();
        return view('Stocks.index', compact('results', 'Sites', 'Articles'));
     }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->Stock->savedata($request, null);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {   
        
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->Stock->savedata($request, $id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
       $this->Article->deletedata($id);
    }

    public function FicheStockEntree($id)
    {
     
    }

    public function CorbeleStock()
    {
        
    }

    public function restaurationStock($Produit)
    {
        
    }
}