<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Models\Utilisateur;

class UtilisateurController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {   
        $Utilisateurs = Utilisateur::whereEtatuser(0)->get();
        return view('Utilisateurs.index', compact('Utilisateurs'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('Utilisateurs.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
        'Nom' => 'required|max:50', 
        'Matricule' => 'required|min:7|max:15',
        'Profil' => 'required'
        ]);
        
        $CurentYear = date('Y');
        //Verifier l'unicité de matricule
        $NbreMatricule = Utilisateur::whereMatricule($request->Matricule)->count('id');
        //Selection du Dernier Enregistrement
        $MaxId = Utilisateur::whereExercice($CurentYear)->max('id');
     
        //Selection des informations de l'enregistrement avec coe Id = $MaxId
        if ($MaxId>0) 
        {
           $InfoUtilisateur = Utilisateur::findOrFail($MaxId); 
           $InfoUtilisateur->Code +=1;

            if ($NbreMatricule == 0) 
            {
              Utilisateur::create([
               'Nom' => $request->Nom,
               'Matricule' => $request->Matricule,
               'Profil' => $request->Profil,
               'Motdepasse' => sha1('12345'),
               'Exercice' => $CurentYear,
               'Code' => $InfoUtilisateur->Code
               ]); 
              session()->flash('message', 'Utilisateur Crée avec success!');
            }
            else
            {
               session()->flash('message', 'Le matricule attribué est deja utilisé par une autre personne');
            } 
       }
       else
       {
          if ($NbreMatricule == 0) 
            {
              Utilisateur::create([
               'Nom' => $request->Nom,
               'Matricule' => $request->Matricule,
               'Profil' => $request->Profil,
               'Motdepasse' => sha1('12345'),
               'Exercice' => $CurentYear,
               'Code' => 1
               ]); 
              session()->flash('message', 'Utilisateur Crée avec success!');
            }
            else
            {
               session()->flash('message', 'Le matricule attribué est deja utilisé par une autre personne');
            }
       }   
        $Utilisateurs = Utilisateur::whereEtatuser(0)->get();
        return redirect( route('Utilisateurs.index',compact('Utilisateurs')));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $Utilisateur = Utilisateur::findOrFail($id);
        return view('Utilisateurs.edit', compact('Utilisateur'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
        'Nom' => 'required|max:50', 
        'Matricule' => 'required|min:7|max:15',
        'Profil' => 'required'
        ]);
        
        //Verifier l'unicité de matricule
        $NbreMatricule = Utilisateur::whereMatriculeAndId($request->Matricule, '!='.$id)->count('id');
         
        if ($NbreMatricule == 0) 
        { 
          $Utilisateur = Utilisateur::findOrFail($id);
          $Utilisateur->update([
              'Nom' => $request->Nom,
              'Matricule' => $request->Matricule,
              'Profil' => $request->Profil
          ]);

          session()->flash('message', 'Utilisateur Modifié avec success!');
          
        }
        else
        {
           session()->flash('message', 'Le matricule attribué est deja utilisé par une autre personne');
        }

       $Utilisateurs = Utilisateur::whereEtatuser(0)->get();
       return redirect( route('Utilisateurs.index',compact('Utilisateurs'))); 
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $Utilisateur = Utilisateur::findOrFail($id);
       $Utilisateur->update(['EtatUser' => 1]);

        session()->flash('messageDelete', 'L\'Utilisateur a ete Supprimer avec success!');
        $Utilisateurs = Utilisateur::whereEtatuser(0)->get();
        return redirect( route('Utilisateurs.index',compact('Utilisateurs')));
    }

    public function restauration($id)
    {
       $Utilisateur = Utilisateur::findOrFail($id);
       $Utilisateur->update([
            'EtatUser' => 0,
            'Motdepasse' => sha1('12345')
        ]);

     $Utilisateurs = Utilisateur::whereEtatuser(0)->get();
     return redirect( route('Utilisateurs.index',compact('Utilisateurs')));
    }

    public function CorbeleUser()
    {
      $Utilisateurs = Utilisateur::whereEtatuser(1)->get();
      return view('Utilisateurs.CorbeleUser', compact('Utilisateurs'));
    }

    public function ShowProfiluser($id)
    {
        $Utilisateur = Utilisateur::findOrFail($id);
        return view('Utilisateurs.ShowProfiluser',compact('Utilisateur'));
    }


     public function updateProfil(Request $request, $id)
    {   
        $Utilisateur = Utilisateur::findOrFail($id);
        $this->validate($request, [
        'HoldPasseWord' => 'required|max:8', 
        'NewPassword' => 'required|max:8',
        'ConfirmNewPassword' => 'required|max:8'
        ]);
        
        $request->HoldPasseWord = sha1($request->HoldPasseWord);
        if ($Utilisateur->Motdepasse==$request->HoldPasseWord) 
        {
        if ($request->ConfirmNewPassword == $request->NewPassword) 
        {
          $request->ConfirmNewPassword = sha1($request->ConfirmNewPassword);
          $Utilisateur->update([
              'Motdepasse' => $request->ConfirmNewPassword
          ]);

          session()->flash('message', 'Votre Mot de Passe a été Modifié avec success!');
        }
        else
        {
           session()->flash('messageDelete', 'les 2 Mot de Passe ne Correspondent pas');
        }
      }
      else
      {
         session()->flash('messageDelete', 'Mot de Passe oublié');
      }
       return redirect( route('ShowProfiluser', compact('id'))); 
    }
}
