<?php

namespace App\Models;
use App\Interfaces\ICommande as ICommande;
use Illuminate\Database\Eloquent\Model;
use App\Models\Articlecommander;
use App\Models\Reception;
use DB;
class Commande extends Model implements ICommande
{   
	protected $tables = "commande";
    protected $fillable = ['Fournisseurid', 'Datereceptionprevue', 'Adressefacturation', 'Numerorefsuivi', 'Dateemission', 'Taxe', 'Site', 'Destinataire', 'Transporteur', 'Notedelacommande', 'Noteinterne', 'Soustotal', 'Taxetotal', 'Auteur', 'Etat', 'Exercice', 'Statut'];

    public function showitems(){
       return $this->get();
     }

     public function savedata($request, $id){
        
        $Savingdata = $this::SavingOrder();
        
        if (is_null($id)){
            if(is_null($Savingdata)){
                $this::create([
                'Fournisseurid'=>$request->Fournisseurid,
                'Datereceptionprevue'=>$request->Datereceptionprevue,
                'Adressefacturation'=> $request->Adressefacturation,
                'Numerorefsuivi'=> $request->Numerorefsuivi,
                'Dateemission'=>$request->Dateemission,
                'Taxe'=>$request->Taxe,
                'Site'=>$request->Site,
                'Destinataire'=>$request->Destinataire,
                'Transporteur'=>$request->Transporteur,
                'Notedelacommande'=> $request->Notedelacommande,
                'Noteinterne'=> $request->Noteinterne,
                'Soustotal'=>0,
                'Taxetotal'=>0,
                'Auteur' => session()->get('Matricule')
                ]);
            }
        }else{
            
            $result = $this->showitem($id);
            $result->update([
            'Fournisseurid'=>$request->Fournisseurid,
            'Datereceptionprevue'=>$request->Datereceptionprevue,
            'Adressefacturation'=> $request->Adressefacturation,
            'Numerorefsuivi'=> $request->Numerorefsuivi,
            'Dateemission'=>$request->Dateemission,
            'Taxe'=>$request->Taxe,
            'Site'=>$request->Site,
            'Destinataire'=>$request->Destinataire,
            'Transporteur'=>$request->Transporteur,
            'Notedelacommande'=> $request->Notedelacommande,
            'Noteinterne'=> $request->Noteinterne,
            'Soustotal'=>$request->Soustotal,
            'Taxetotal'=>$request->Taxetotal,
            'Auteur' => session()->get('Matricule')
            ]);
         }
    }

    public function showitem($id){
    	return $this::findOrFail($id);
    }

    public function deletedata($id){
       $Item = $this->showitem($id);
  
        $Item->update([
            'Etat' => 1
        ]);
         session()->flash('messageDelete', 'Commande supprimée avec success');
     }

   public function SavingOrder(){
        return $this::whereStatutAndEtatAndAuteur(0,0,session()->get('Matricule'))->max('id');
   }  

   public function EndingOrdering($Order){
       $Order = $this->showitem($Order);
       $Order->update([
        'Etat'=>1
       ]);
   }

   public function ArticleAttachedToOrder($Order){
       return $Articles=DB::table('articlescommanders')
                        ->join('commandes', 'commandes.id', '=', 'articlescommanders.Commandeid')
                        ->join('articles', 'articles.id', '=', 'articlescommanders.Articleid')
                        ->join('sites', 'sites.id', '=', 'commandes.Site')
                        ->select(DB::raw('Quantite-Qterecu as Qtreste, articlescommanders.id, articles.Code, articles.Description, sites.Nom, articlescommanders.Taxe, articlescommanders.Valeurunitaire, articlescommanders.Totalunitaire, articlescommanders.recu, articlescommanders.Qterecu, articlescommanders.Auteur, articlescommanders.created_at, articlescommanders.updated_at, articlescommanders.Etat'))->where('articlescommanders.Etat',0)->where('articlescommanders.Commandeid',$Order)->get();
   }

   public function OrderNotReceived(){
       
       return $this::whereStatut(0)->get();
   }

    public function markReceived($Order){
      $Articlecommanders = Articlecommander::whereCommandeidAndEtat($Order,0)->get();
      $Commande = $this->showitem($Order);
      $received = 0;
      $notreceived = 0;
      foreach ($Articlecommanders as $Articlecommander) {
          if($Articlecommander->recu==1){

             $received +=1;
          }else{
            $notreceived += 1;
          }
      } 
   
      if ($notreceived==0) {
         $Commande->update([
            'Statut'=>1
         ]);
         
       }else{
         $Commande->update([
            'Statut'=>0
         ]);
       }
    }

}
