<?php

namespace App\Models;
use App\Interfaces\IFournisseur as IFournisseur;
use Illuminate\Database\Eloquent\Model;

class Fournisseur extends Model implements IFournisseur
{
    protected $table = 'fournisseurs';
    protected $fillable = ['Nom', 'Personnecontactnom','Personnecontactprenom', 'Adresse', 'Telephone', 'Fax', 'Adressecouriel', 'Auteur'];

    public function showitems(){
        return $this->get();
     }

     public function savedata($request, $id){

        
         if (is_null($id)) {
             $this::create([
            'Nom'=>$request->Nom,
            'Personnecontactnom'=>$request->Personnecontactnom,
            'Personnecontactprenom'=>$request->Personnecontactprenom, 
            'Adresse'=>$request->Adresse,
            'Telephone'=>$request->Telephone,
            'Fax'=>$request->Fax,
            'Adressecouriel'=>$request->Adressecouriel,
            'Auteur' => session()->get('Matricule')
            ]);
       
         }else{
            
            $result = $this->showitem($id);
            $result->update([
            'Nom'=>$request->Nom,
            'Personnecontactnom'=>$request->Personnecontactnom,
            'Personnecontactprenom'=>$request->Personnecontactprenom, 
            'Adresse'=>$request->Adresse,
            'Telephone'=>$request->Telephone,
            'Fax'=>$request->Fax,
            'Adressecouriel'=>$request->Adressecouriel,
            'Auteur' => session()->get('Matricule')
            ]);
         }

    }

    public function showitem($id){
    	return $this::findOrFail($id);
    }

    public function deletedata($id){
       $Item = $this->showitem($id);
  
        $Item->update([
            'Etat' => 1
        ]);

         session()->flash('messageDelete', 'Fournisseur supprimé avec success');
     }
}
