<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use App\Models\Article;
use App\Interfaces\IArticle;
use App\Models\Client;
use App\Interfaces\IClient;
use App\Models\Categorie;
use App\Interfaces\ICategorie;
use App\Models\Fournisseur;
use App\Interfaces\IFournisseur;
use App\Models\Site;
use App\Interfaces\ISite;
use App\Models\Taxe;
use App\Interfaces\ITaxe;
use App\Models\Transporteur;
use App\Interfaces\ITransporteur;
use App\Models\Commande;
use App\Interfaces\ICommande;
use App\Interfaces\IArticlecommander;
use App\Models\Articlecommander;
use App\Models\Reception;
use App\Interfaces\IReception;
use App\Models\Stock;
use App\Interfaces\IStock;
use App\Models\Transfert;
use App\Interfaces\ITransfer;
class AppServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        //
    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->bind(IArticle::class, Article::class);
        $this->app->bind(IClient::class, Client::class);
        $this->app->bind(ICategorie::class, Categorie::class);
        $this->app->bind(IFournisseur::class, Fournisseur::class);
        $this->app->bind(ITaxe::class, Taxe::class);
        $this->app->bind(ISite::class, Site::class);
        $this->app->bind(ITransporteur::class, Transporteur::class);
        $this->app->bind(ICommande::class, Commande::class);
        $this->app->bind(IArticlecommander::class, Articlecommander::class);
        $this->app->bind(IReception::class, Reception::class);
        $this->app->bind(IStock::class, Stock::class);
        $this->app->bind(ITransfer::class, Transfert::class);
    }
}
