<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateExclusionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('exclusions', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('Produit');
            $table->integer('UniteVente');
            $table->double('Quantite');
            $table->double('QtePiece');
            $table->double('Montant');
            $table->text('Motif');
            $table->dateTime('DateExclusion')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->integer('Exercice');
            $table->integer('Etat');
            $table->integer('Auteur');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('exclusions');
    }
}
