 @extends('layout.base', ['title' => 'StockApps - Liste Categorie'])

@section('content')

 <!-- /. NAV SIDE  -->
<div id="page-wrapper" >
<div id="page-inner">
    <div class="row">
        <div class="col-md-12">
         <h2>Categorie</h2>   
                       
        </div>
    </div>
     <!-- /. ROW  -->
     <hr />

            <div class="row">
                <div class="col-md-12">
                    <!-- Advanced Tables -->
                    <div class="panel panel-default">
                        <div class="panel-heading">
                        
                            <div class="panel-heading">
                             Liste de Stocks
                              <button class="btn btn-info pull-right" data-toggle="modal" data-target="#modal-default" style="text-decoration: none;color: white; margin-top: -5px"> <i class="fa fa-plus"></i> Ajouter un stock </button>
                        </div>
                        </div>
                        </div>

                        <div class="panel-body">
                            <div class="table-responsive">
                                <table class="table table-striped table-bordered table-hover" id="dataTables-example">
                                    <thead>
                                        <tr>
                                            <th>Article</th>
                                            <th>Site</th>
                                            <th>Quantite</th>
                                            <th>Qté Idéale</th>
                                            <th>Qté Sécurité</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($results as $result)
                                        <tr class="odd gradeX">
                                            <td>{{$result->Articleid}}</td>
                                            <td>{{$result->Siteid}}</td>
                                            <td>{{$result->Quantite}}</td>
                                            <td>{{$result->Quantiteideal}}</td>
                                            <td>{{$result->Quantitesecurite}}</td>
                                            <td class="center f-icon">
                                                <form action="{{ route('Stock.destroy',$result) }}" method="POST">
                                                <a href="{{ route('Stock.edit',$result)}}"><i class="fa fa-pencil"></i></a>
                                                
                                                    {{ csrf_field() }}
                                                    {{method_field('DELETE')}}
                                                    <button><i class="fa fas-trash"></i>
                                                        </button>
                                                        <!-- <input type="submit" name="" value="<i class='fa fa-user'></i>"> -->
                                                    
                                                </form>
                                                
                                            </td>
                                          
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

    </div>
</div>


<!-- /. PAGE INNER  -->
  <div class="modal fade" id="modal-default">
        <div class="modal-dialog modal-md">
          <div class="modal-content">
            <div class="modal-header">
              <h4 class="modal-title">ENREGISTREMENT D'UN NOUVEAU STOCK</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <form method="POST" action="{{route('Stock.store')}}" enctype="multipart/form-data" onsubmit='return confirm("Etez - vous sur de cette Operation ?")'>
                {{ csrf_field() }}
                  <div class="card-body">
                    <div class="row">

                      <div class="col-md-6">
                        <div class="form-group">
                          <label>Site *</label>
                           <select name="Siteid" class="form-control">
                            <option></option>
                            @foreach($Sites as $Site)
                             <option value="{{$Site->id}}">{{$Site->Nom}}</option>
                            @endforeach 
                           </select>
                        </div>
                      </div>

                      <div class="col-md-6">
                        <div class="form-group">
                          <label>Article *</label>
                           <select name="Articleid" class="form-control">
                            <option></option>
                            @foreach($Articles as $Article)
                             <option value="{{$Article->id}}">{{$Article->Code}}</option>
                            @endforeach 
                           </select>
                        </div>
                      </div>

                      <div class="col-md-6" style="">
                        <div class="form-group">
                          <label>Qté Idéale *</label>
                            <input type="number" name="Quantiteideal" class="form-control" value="{{old('Quantiteideal')}}">
                          {!! $errors->first('Quantiteideal', '<span class="error">:message</span>') !!}
                        </div>
                      </div>


                     <div class="col-md-6" style="">
                        <div class="form-group">
                          <label>Qté Sécurite *</label>
                            <input type="number" name="Quantitesecurite" class="form-control" value="{{old('Quantitesecurite')}}">
                          {!! $errors->first('Quantitesecurite', '<span class="error">:message</span>') !!}
                        </div>
                      </div>

                   
                      <div class="col-md-6">
                        <div class="card-footer">
                          <button type="submit" class="btn btn-success swalDefaultSuccess" onclick='return confirm("Etez -vous sur d\'effectuer cette Operation ?")'><i class="fas fa-save"></i>Valider</button>
                        </div>
                      </div>

                    </div>
                  </div>

              </form>
            </div>
            <div class="modal-footer justify-content-between">
              <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
          </div>
          <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
      </div>


@stop