@extends('layout.base', ['title' => 'StockApps - Liste des Ventes'])

@section('content')
              <div id="page-wrapper" >
            <div id="page-inner">
                <div class="row">
                   <div class="col-md-12">
                      <h2 style="color: blue;font-weight: bold;">TRANSFERER DU STOCK</h2>  
                   <h5>Liste des transferer </h5>
                  </div>
                </div>
               <hr />
                 <!-- /. ROW  -->
                
               
            <div class="row">
                <div class="col-md-12">
                <form method="POST" action="{{route('display_stock_available')}}">
                  {{ csrf_field() }}
                  <div class="col-md-6">
                          <label>Transferer de ce site </label>
                          <div class="form-inline">
                             <select name="Site" class="form-control">
                                 <option></option>
                                 @foreach($Sites as $Site)
                                   <option value="{{$Site->id}}">{{$Site->Nom}}</option>
                                 @endforeach
                             </select> 

                              <button type="submit" name="Enregistrer" class="btn btn-success swalDefaultSuccess">Rechercher</button>
                          </div>
                      </div>
                </form>

                <form method="POST" action="{{route('Receptions.store')}}" onsubmit='return confirm("Etez - vous sur de cette Operation ?")'>
                {{ csrf_field() }}
                  <div class="card-body">

                    <div class="row">

                      <div class="col-md-6">
                          <label>Date de reception</label>
                          <div class="form-inline">
                             <input type="date" name="Datereception" class="form-control" required="required">
                          </div>
                      </div>
                      
                    </div> <br /> <hr>



                    
                    <div class="panel-body">
                            <div class="table-responsive">
                                <table class="table table-hover table-sm">
                                    <thead>
                                        <tr>
                                            <th>Article</th>
                                            <th>Description</th>
                                            <th>Site</th>
                                            <th>Qté recue</th>
                                            <th>Cout Unitqire</th>
                                            <th>Qté en Stock</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                      @foreach($results as $result)
                                         <tr class="odd gradeX">
                                            <td style="display: none;"><input type="number" class="form-control" name="Identif[]" value="{{$result->id}}"></td>
                                             <td>{{$result->Code}}</td>
                                            <td>{{ $result->Description}}</td>
                                            <td>{{ $result->Nom}}</td>
                                            <td><input type="number" class="form-control" name="Qterecu[]" value="{{$result->Qtereste}}" max="" min="0"></td>
                                            <td>{{ $result->Description}}</td>
                                            <td>{{$result->Description}}</td>
                                            <td><button class="btn btn-info pull-right" value="{{$result->id}}" onclick="getReceptionId(this)" data-toggle="modal" data-target="#modal-default"> <i class="fa fa-plus"></i></button></td>
                                            <td>
                                            </td>
                                        </tr>
                                      @endforeach  
                                    </tbody>
                                </table>
                            </div>
                        </div>

                
                    <div class="row"> <br /> <hr>

                      <div class="col-md-4">
                        <label>Note de la commande</label>
                          <div class="form-inline">
                            <textarea name="Notedelacommande" class="form-control" cols="100" rows="3"></textarea> 
                          </div>
                      </div>

                      
                     </div> <br /> <hr>
                 
                    

                     <div class="row">
                        <div class="col-md-12">
                         <div class="card-footer">
                          <button type="submit" name="Enregistrer" class="btn btn-success swalDefaultSuccess" onclick='return confirm("Etez -vous sur d\'effectuer cette Operation ?")'><i class="fa fa-plus"></i> Enregistrer</button>

                           <button type="submit" class="btn btn-danger" onclick='return confirm("Etez -vous sur d\'effectuer cette Operation ?")'><i class="fa fa-cancel"></i> Annuler</button>
                        </div>

                     </div>
                        </div>
                        
                      </div>
                    </div>

              </form>

             
                </div>
            </div>
        </div>
               
    </div>


  <!-- /. PAGE INNER  -->
  <div class="modal fade" id="modal-default">
        <div class="modal-dialog modal-md">
          <div class="modal-content">
            <div class="modal-header">
              <h4 class="modal-title">TRANSFERER LE STOCK VERS</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <form method="POST" action="{{route('Transfers.store')}}" enctype="multipart/form-data" onsubmit='return confirm("Etez - vous sur de cette Operation ?")'>
                {{ csrf_field() }}
                  <div class="card-body">
                    <div class="row">

                      <div class="col-md-6" style="display: none;">
                        <div class="form-group">
                          <label>Reception *</label>
                            <input type="text" name="Reception" class="form-control" value="{{old('Reception')}}" id="Reception">
                          {!! $errors->first('Reception', '<span class="error">:message</span>') !!}
                        </div>
                      </div>


                      <div class="col-md-6" style="display: none;">
                        <div class="form-group">
                          <label>Origine *</label>
                            <input type="text" name="Origine" class="form-control" value="{{old('Origine')}}" id="Origine">
                          {!! $errors->first('Origine', '<span class="error">:message</span>') !!}
                        </div>
                      </div>

                      <div class="col-md-6">
                        <div class="form-group">
                          <label>Destination *</label>
                           <select name="Destination" class="form-control">
                            @foreach($Sites as $Site)
                             <option value="{{$Site->id}}">{{$Site->Nom}}</option>
                            @endforeach 
                           </select>
                        </div>
                      </div>

                       <div class="col-md-6">
                        <div class="form-group">
                          <label>Quantité *</label>
                            <input type="number" name="Quantite" class="form-control" value="{{old('Quantite')}}">
                          {!! $errors->first('Quantite', '<span class="error">:message</span>') !!}
                        </div>
                      </div>
                     
                     <div class="col-md-6">
                        <div class="form-group">
                          <label>Demandé Par *</label>
                           <select name="Demandeur" class="form-control">
                            @foreach($Utilisateurs as $Utilisateur)
                             <option value="{{$Utilisateur->id}}">{{$Utilisateur->Nom}}</option>
                            @endforeach 
                           </select>
                        </div>
                      </div>
                   
                      <div class="col-md-6">
                        <div class="card-footer">
                          <button type="submit" class="btn btn-success swalDefaultSuccess" onclick='return confirm("Etez -vous sur d\'effectuer cette Operation ?")'><i class="fas fa-save"></i>Transferer</button>
                        </div>
                      </div>

                    </div>
                  </div>

              </form>
            </div>
            <div class="modal-footer justify-content-between">
              <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
          </div>
          <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
      </div>


    
@endsection 

<script type="text/javascript">
   function getReceptionId(va){
    var Reception = $(va).val();

    $.get('{{route('getReceptionId')}}',
    {Reception:Reception},
    function(data){
      var donnee = data.split("#");
      $("#Reception").val(donnee[0]);
      $("#Origine").val(donnee[1]);
    });
  }
</script>